%This program is used to compute the control limits by using bootstrap method.
%By using this method, we compute 100 control limits for 100 sample. 
%(each sample contains n subjects and each subjects contains J observations)
%n is the number of subjects
%d out 10 is the sampling rate
%k is the reference value
%B is the bootstrapping times
%[hhl,hhu] is the range that control limit take value in.

function cl=control_limit_ar2_boots(n,d,k,B,hhu,hhl)
cl=zeros(100,1);
n1=10;
n2=d;
L=1000;
J=d*L/n1;
for j=1:100
    hu=hhu;hl=hhl;
m=textread(['univariate_spc_m_08n',num2str(n),'_J',num2str(J),'1000ar2.txt']);
mv=textread(['univariate_spc_m_08n',num2str(n),'_J',num2str(J),'1000ar2var.txt']);
load(['rawdataic_for_univariate_spc_1000_08n',num2str(n),'_J',num2str(J),'ar2boots.mat'],'x1','y1')
m0=m(j,:);
s0=sqrt(mv(j,:));
x=x1(:,:,j);
y=y1(:,:,j);
clear m mv x1 y1
h0=hu/2+hl/2;
ts=ATS_Dar2_data(x,y,m0,s0,n2,n1,k,h0);
nn=length(ts);
Boots=ceil(rand(B,1).*nn);
ats=mean(ts(Boots));
clear ts
while (ats>102 || ats<98)
    if ats>102
        hu=h0;
    else
        hl=h0;
    end
    if hu-hl>0.05
        h0=hu/2+hl/2;
ts=ATS_Dar2_data(x,y,m0,s0,n2,n1,k,h0);
nn=length(ts);
Boots=ceil(rand(B,1).*nn);
ats=mean(ts(Boots));
clear ts
    else
        break
        h0=hu/2+hl/2;
    end
end
cl(j)=h0;
end
